/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.block;

import dev.toma.gunsrpg.common.block.BaseBlock;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.container.CookerContainer;
import dev.toma.gunsrpg.common.init.Skills;
import dev.toma.gunsrpg.common.tileentity.CookerTileEntity;
import dev.toma.gunsrpg.util.SkillUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class CookerBlock
extends BaseBlock {
    private static final ITextComponent TITLE = new TranslationTextComponent("container.cooker");

    public CookerBlock(String name) {
        super(name, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(2.2f, 16.0f).harvestTool(ToolType.PICKAXE).harvestLevel(1));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH)).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q)).booleanValue()) {
            double y = pos.func_177956_o() + 1;
            if (random.nextDouble() <= 0.2) {
                world.func_184148_a(null, (double)pos.func_177958_n(), y, (double)pos.func_177952_p(), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            double randomX = (random.nextDouble() - random.nextDouble()) * 0.4;
            double randomZ = (random.nextDouble() - random.nextDouble()) * 0.4;
            world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)pos.func_177958_n() + 0.5 + randomX, y + 0.05, (double)pos.func_177952_p() + 0.5 + randomZ, 0.0, 0.0, 0.0);
        }
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? 12 : 0;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState oldState, boolean p_196243_5_) {
        TileEntity tile;
        if (!state.func_203425_a(oldState.func_177230_c()) && (tile = world.func_175625_s(pos)) instanceof CookerTileEntity) {
            CookerTileEntity tileEntity = (CookerTileEntity)tile;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tileEntity);
            tileEntity.getRecipesForAwardsWithExp(world, Vector3d.func_237489_a_((Vector3i)pos));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, oldState, p_196243_5_);
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World level, BlockPos pos) {
        return Container.func_178144_a((TileEntity)level.func_175625_s(pos));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CookerTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J}).func_206894_a(new Property[]{BlockStateProperties.field_208190_q});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        if (PlayerData.hasActiveSkill(player, Skills.LOCAL_CHEF)) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this.func_220052_b(state, world, pos), (BlockPos)pos);
        } else {
            ((ServerPlayerEntity)player).func_241151_a_(SkillUtil.getMissingSkillText(Skills.LOCAL_CHEF), ChatType.GAME_INFO, Util.field_240973_b_);
        }
        return ActionResultType.CONSUME;
    }

    @Nullable
    public INamedContainerProvider func_220052_b(BlockState state, World world, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, inv, player) -> new CookerContainer(id, inv, (CookerTileEntity)world.func_175625_s(pos)), TITLE);
    }
}

